jQuery(document).ready(function($) {
    
    // Media Uploader for Watermark Image
    var watermarkUploader;
    
    $('#upload_watermark_image').on('click', function(e) {
        e.preventDefault();
        
        if (watermarkUploader) {
            watermarkUploader.open();
            return;
        }
        
        watermarkUploader = wp.media({
            title: 'Select Watermark Image/Logo',
            button: {
                text: 'Use this image'
            },
            multiple: false,
            library: {
                type: 'image'
            }
        });
        
        watermarkUploader.on('select', function() {
            var attachment = watermarkUploader.state().get('selection').first().toJSON();
            var imageUrl = attachment.url;
            
            console.log('Image selected:', imageUrl);
            
            // Set the image URL in the input field
            $('#yo_towebp_watermark_image').val(imageUrl);
            
            // Show preview immediately
            var $inputField = $('#yo_towebp_watermark_image');
            var $removeBtn = $('#remove_watermark_image');
            var $previewContainer = $('.watermark-image-preview');
            
            // Remove old preview if exists
            $previewContainer.remove();
            
            // Create new preview
            var previewHtml = '<div class="watermark-image-preview">' +
                '<img src="' + imageUrl + '" alt="Watermark preview" style="max-width: 200px; max-height: 100px; display: block; margin-top: 10px; border: 1px solid #ddd; padding: 5px; background: repeating-conic-gradient(#e0e0e0 0% 25%, #ffffff 0% 50%) 50% / 20px 20px;">' +
                '</div>';
            
            // Insert preview after remove button or after input
            if ($removeBtn.length > 0) {
                $removeBtn.after(previewHtml);
                $removeBtn.show();
            } else {
                // Create remove button if doesn't exist
                var $newRemoveBtn = $('<button type="button" class="button" id="remove_watermark_image" style="margin-left: 5px;">Remove</button>');
                $inputField.after($newRemoveBtn);
                $newRemoveBtn.after(previewHtml);
            }
            
            // Show notice to save
            var $notice = $('#watermark-save-notice');
            if ($notice.length === 0) {
                $notice = $('<div id="watermark-save-notice" class="notice notice-warning inline" style="margin: 10px 0; padding: 10px;"><p><strong>Don\'t forget to click "Save Changes" to apply the watermark image!</strong></p></div>');
                $('.watermark-image-settings').append($notice);
            }
            $notice.show();
            
            // Update watermark preview with new logo
            updateWatermarkPreview();
        });
        
        watermarkUploader.open();
    });
    
    // Handle remove button (use event delegation for dynamically added buttons)
    $(document).on('click', '#remove_watermark_image', function(e) {
        e.preventDefault();
        if (confirm('Remove watermark image?')) {
            console.log('Removing watermark image');
            
            $('#yo_towebp_watermark_image').val('');
            $('.watermark-image-preview').remove();
            $(this).hide();
            
            // Show notice to save
            var $notice = $('#watermark-save-notice');
            if ($notice.length === 0) {
                $notice = $('<div id="watermark-save-notice" class="notice notice-warning inline" style="margin: 10px 0; padding: 10px;"><p><strong>Don\'t forget to click "Save Changes" to apply the changes!</strong></p></div>');
                $('.watermark-image-settings').append($notice);
            }
            $notice.show();
            
            // Update preview to hide logo
            updateWatermarkPreview();
        }
    });
    
    // Toggle watermark type settings
    function toggleWatermarkType() {
        var type = $('#yo_towebp_watermark_type').val();
        if (type === 'text') {
            $('.watermark-text-settings').show();
            $('.watermark-image-settings').hide();
            $('#yo_towebp_watermark_color').closest('tr').show();
        } else {
            $('.watermark-text-settings').hide();
            $('.watermark-image-settings').show();
            $('#yo_towebp_watermark_color').closest('tr').hide();
        }
    }
    
    $('#yo_towebp_watermark_type').on('change', toggleWatermarkType);
    toggleWatermarkType();
    
    // Watermark Preview Update
    function updateWatermarkPreview() {
        const enabled = $('#yo_towebp_watermark_enabled').is(':checked');
        const type = $('#yo_towebp_watermark_type').val();
        const text = $('#yo_towebp_watermark_text').val();
        const imageUrl = $('#yo_towebp_watermark_image').val();
        const sizePercent = $('#yo_towebp_watermark_size').val();
        const sizeType = $('#yo_towebp_watermark_size_type').val();
        const opacity = $('#yo_towebp_watermark_opacity').val();
        const position = $('input[name="yo_towebp_watermark_position"]:checked').val();
        const color = $('#yo_towebp_watermark_color').val();
        
        const $previewText = $('.watermark-preview-text');
        const $previewLogo = $('.watermark-preview-logo');
        const $previewImage = $('.watermark-preview-image');
        
        // Get preview container dimensions
        const previewWidth = $previewImage.width() || 400;
        const previewHeight = $previewImage.height() || 300;
        
        // Calculate base dimension for size calculation
        let baseDimension;
        switch(sizeType) {
            case 'height':
                baseDimension = previewHeight;
                break;
            case 'min':
                baseDimension = Math.min(previewWidth, previewHeight);
                break;
            case 'max':
                baseDimension = Math.max(previewWidth, previewHeight);
                break;
            case 'width':
            default:
                baseDimension = previewWidth;
                break;
        }
        
        // TEXT WATERMARK
        if (enabled && type === 'text' && text) {
            $previewText.show();
            $previewLogo.hide();
            $previewText.text(text);
            
            const fontSize = (baseDimension * sizePercent) / 100;
            
            $previewText.css({
                'font-size': fontSize + 'px',
                'opacity': opacity / 100,
                'color': color,
                'background': 'none',
                'padding': '0',
                'border-radius': '0',
                'text-shadow': '1px 1px 2px rgba(0,0,0,0.5)'
            });
            
            // Position watermark
            applyWatermarkPosition($previewText, position);
            
        // IMAGE/LOGO WATERMARK
        } else if (enabled && type === 'image' && imageUrl) {
            $previewText.hide();
            $previewLogo.show();
            
            // Calculate logo size (percentage of base dimension)
            const logoSize = (baseDimension * sizePercent) / 100;
            
            $previewLogo.css({
                'max-width': logoSize + 'px',
                'max-height': logoSize + 'px',
                'opacity': opacity / 100,
                'width': 'auto',
                'height': 'auto'
            });
            
            // Update logo src if changed
            if ($previewLogo.attr('src') !== imageUrl) {
                $previewLogo.attr('src', imageUrl);
            }
            
            // Position watermark
            applyWatermarkPosition($previewLogo, position);
            
        } else {
            $previewText.hide();
            $previewLogo.hide();
        }
    }
    
    // Helper function to apply position
    function applyWatermarkPosition($element, position) {
        // Reset all positions
        $element.css({ 
            top: 'auto', 
            bottom: 'auto', 
            left: 'auto', 
            right: 'auto',
            transform: 'none'
        });
        
        switch(position) {
            case 'top-left':
                $element.css({ top: '10px', left: '10px' });
                break;
            case 'top-center':
                $element.css({ top: '10px', left: '50%', transform: 'translateX(-50%)' });
                break;
            case 'top-right':
                $element.css({ top: '10px', right: '10px' });
                break;
            case 'middle-left':
                $element.css({ top: '50%', left: '10px', transform: 'translateY(-50%)' });
                break;
            case 'center':
                $element.css({ top: '50%', left: '50%', transform: 'translate(-50%, -50%)' });
                break;
            case 'middle-right':
                $element.css({ top: '50%', right: '10px', transform: 'translateY(-50%)' });
                break;
            case 'bottom-left':
                $element.css({ bottom: '10px', left: '10px' });
                break;
            case 'bottom-center':
                $element.css({ bottom: '10px', left: '50%', transform: 'translateX(-50%)' });
                break;
            case 'bottom-right':
                $element.css({ bottom: '10px', right: '10px' });
                break;
        }
    }
    
    // Watermark controls
    $('#yo_towebp_watermark_enabled').on('change', function() {
        $('.watermark-settings').toggle($(this).is(':checked'));
        updateWatermarkPreview();
    });
    
    $('#yo_towebp_watermark_text, #yo_towebp_watermark_color, #yo_towebp_watermark_type, #yo_towebp_watermark_size_type, #yo_towebp_watermark_image').on('input change', updateWatermarkPreview);
    
    $('#yo_towebp_watermark_size').on('input', function() {
        $('#watermark-size-value').text($(this).val() + '%');
        updateWatermarkPreview();
    });
    
    $('#yo_towebp_watermark_opacity').on('input', function() {
        $('#watermark-opacity-value').text($(this).val());
        updateWatermarkPreview();
    });
    
    $('input[name="yo_towebp_watermark_position"]').on('change', function() {
        $('.watermark-position-btn').removeClass('active');
        $(this).parent().addClass('active');
        updateWatermarkPreview();
    });
    
    // Initialize watermark preview
    if ($('#yo_towebp_watermark_enabled').is(':checked')) {
        $('.watermark-settings').show();
        updateWatermarkPreview();
    } else {
        $('.watermark-settings').hide();
    }
    
    // Hide save notice after form submit
    $('form').on('submit', function() {
        $('#watermark-save-notice').remove();
    });
    
    // Crop ratio toggle
    $('#yo_towebp_crop_enabled').on('change', function() {
        $('.crop-settings').toggle($(this).is(':checked'));
    });
    
    if ($('#yo_towebp_crop_enabled').is(':checked')) {
        $('.crop-settings').show();
    } else {
        $('.crop-settings').hide();
    }
    
    // Update range value displays
    $('#yo_towebp_quality').on('input', function() {
        $('#quality-value').text($(this).val());
    });
    
    // Position button styling
    $('.watermark-position-btn').on('click', function() {
        $('.watermark-position-btn').removeClass('active');
        $(this).addClass('active');
    });
    
    // Set active position button on load
    const activePosition = $('input[name="yo_towebp_watermark_position"]:checked').val();
    $('input[name="yo_towebp_watermark_position"][value="' + activePosition + '"]').parent().addClass('active');
    
});
